//#version 120
// It was expressed that some drivers required this next line to function properly
//precision highp float;
#define MAX_LIGHTS 8
in vec3 alightVec[MAX_LIGHTS];
in vec3 aeyeVec[MAX_LIGHTS];
in vec2 texCoord;
in vec3 vNormal;
in vec3 vPos;

uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];
uniform sampler2D colorMap;
uniform sampler2D normalMap;
uniform sampler2D lightMap;
uniform sampler2D specularMap;

uniform vec3 camPos;
uniform vec3 objPos;

//uniform vec3 cameraeyevector;
//uniform float invRadius;
//out vec4 gl_FragColor;

//--------------------------------------------------------------------------------------------

varying vec3 alVec[MAX_LIGHTS];
varying vec3 avVec[MAX_LIGHTS];
//varying vec3 aeyeVec[MAX_LIGHTS];

uniform float testvalue;
uniform vec4 glColor;

void main (void)
{
vec4 result;
vec3 eVec;

vec3 lightVec;
vec3 eyeVec;
vec4 accvDiffuse = vec4(0.0);
vec4 accvSpecular = vec4(0.0);
float distSqr;
vec3 lVec;
vec3 vVec;
float att;
vec4 base;
vec4 vAmbient;
vec3 bump;
float diffuse;
vec4 vDiffuse;
vec4 vSpecular;
float specular;
vec3 nrmltexture;

	base = texture2D(colorMap, texCoord);
	vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
for (int i=0; i<MAX_LIGHTS; i++)
   {
	if (lightsEnabled[i]>0.0)
	{
        lightVec=alightVec[i];
        eyeVec=aeyeVec[i];
	distSqr = dot(lightVec, lightVec);
	att = clamp(1.0 - lightsinvRadius[i] * sqrt(distSqr), 0.0, 1.0);
	lVec = lightVec * inversesqrt(distSqr);
	vVec = normalize(eyeVec);

    //nrmltexture= texture2D(normalMap, texCoord).xyz;
    //nrmltexture.z=nrmltexture.z*-1.0f;
	//bump = normalize(nrmltexture * 2.0f - 1.0);
	bump = normalize( texture2D(normalMap, texCoord).xyz * 2.0f - 1.0);
	//bump = vec3(0.0,0.0,1.0);

	//diffuse = max( dot(lVec, bump), 0.0 );
	diffuse = clamp( dot(lVec, bump), 0.0, 1.0 );
//	vDiffuse = gl_LightSource[i].diffuse * gl_FrontMaterial.diffuse * diffuse *
	vDiffuse = gl_LightSource[i].diffuse * diffuse *
		texture2D(lightMap, vec2(diffuse-0.01,lightMapSelect[i]));
	accvDiffuse = accvDiffuse + vDiffuse;

	//specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0),
	           //gl_FrontMaterial.shininess );

	//specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), gl_FrontMaterial.shininess ) * texture2D(specularMap, texCoord).r;
	specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), 32.0 ) * texture2D(specularMap, texCoord).r; //here shiness is replaced with 1.0, should introduce material functionality in obj loader //16.0

	//vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;
//	vSpecular = gl_LightSource[i].specular * gl_FrontMaterial.specular * specular *
	vSpecular = gl_LightSource[i].specular * specular * texture2D(lightMap, vec2(specular-0.01,lightMapSelect[i]));
	accvSpecular = accvSpecular + vSpecular;
	}
   }
	//gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular) * att;
	gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular);

	//gl_FragColor = vec4(vNormal.x,vNormal.y,vNormal.z,1.0);
	//gl_FragColor = ( vAmbient*base + vDiffuse*base + vSpecular) * att;
	//gl_FragColor = ( vAmbient*base + vDiffuse*base + texture2D(lightMap, vec2(1.0-specular,0))) * att;

//---------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------

/*
	//gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular);
	//gl_FragColor = ( vAmbient*base + vDiffuse*base + vSpecular) * att;
	//gl_FragColor = ( vAmbient*base + vDiffuse*base + texture2D(lightMap, vec2(1.0-specular,0))) * att;
	eVec=aeyeVec[0];
	vVec=avVec[0];
	//float alpha = clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0);
	//float alpha = clamp(dot(vVec, vVec), 0.0, 1.0);
	//float alpha = (1.0f-clamp(((abs(clamp(vVec , 0.0, 1.0)-0.5))*2),0.0,1.0));
	float alpha = texture2D(lightMap, vec2(0.0,clamp(vVec/1.0, 0.1, 1.0))) ;
	//result=( vAmbient*base + clamp(accvDiffuse,1.0,1.0)*base );
	result=( clamp(accvDiffuse,1.0,1.0)*base );
	//result=vec4(0.5);
	//result = texture2D(colorMap, texCoord);
	gl_FragColor = result*alpha;
*/
//---------------------------------------------------------------------------------------------------------------------------------------
	//vVec=aeyeVec[0];

//        cameyevector[0] = objCamera.mView.x - objCamera.mPos.x;
//  eyeVec = dot(-normalize(n), normalize(cameyevector));
	
	//vec3 cameyevector = (objPos-camPos);
	
	//vec3 camPos_=camPos;
	//camPos_.y=mix(vPos.y,camPos.y,0.5*testvalue);

	vec3 cameyevector = (vPos-camPos);
    eyeVec = dot(-normalize(vNormal), normalize(cameyevector));

	vVec=eyeVec;


	//float alpha = texture2D(lightMap, vec2(0.0,pow(float(clamp(vVec, 0.1, 0.98)),1.0)));
	float alpha = texture2D(lightMap, vec2(0.0,clamp(vVec, 0.1, 0.98)));
	float enhance = length(cameyevector)*0.1;
	base.a/=pow(enhance,0.9)/1.4;
	base.a/=1.3;
	result=( clamp(accvDiffuse,0.99,0.99)*base );
	gl_FragColor = result*alpha/1.3*glColor;///testvalue;
	//gl_FragColor = vec4(1,0,0,1);

//---------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------

}

/*
#define MAX_LIGHTS 8
//varying float aatt[MAX_LIGHTS];
varying vec3 alVec[MAX_LIGHTS];
varying vec3 avVec[MAX_LIGHTS];

varying vec3 eyeVec[MAX_LIGHTS];

varying vec2 texCoord;
uniform float lightsEnabled[MAX_LIGHTS];
//uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];
uniform sampler2D colorMap;
uniform sampler2D normalMap;
uniform sampler2D lightMap;
uniform sampler2D specularMap;
//uniform float invRadius;

void main (void)
{
vec3 lVec;
vec3 vVec;
float att;
vec4 base;
vec3 bump;
vec4 vAmbient;
float diffuse;
vec4 vDiffuse;
float specular;
vec4 vSpecular;

vec4 accvDiffuse = vec4(0.0);
vec4 accvSpecular = vec4(0.0);

vec4 result;
vec3 eVec;

	base = texture2D(colorMap, texCoord);
	vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
	//att=1.0;//aatt[0];
for (int i=0; i<MAX_LIGHTS; i++)
   {
	if (lightsEnabled[i]>0.0)
	{
	lVec=alVec[i];
	vVec=avVec[i];
	bump = normalize(texture2D(normalMap, texCoord).xyz * 2.0 - 1.0);

	diffuse = max( dot(lVec, bump), 0.0 );
//	vDiffuse = gl_LightSource[i].diffuse * gl_FrontMaterial.diffuse * diffuse *
	vDiffuse = gl_LightSource[i].diffuse * diffuse *
		texture2D(lightMap, vec2(diffuse-0.01,lightMapSelect[i]));
	accvDiffuse = accvDiffuse + vDiffuse;

//	specular = clamp(dot(eyeVec[i], vVec), 0.0, 1.0);
//	specular = clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0);

	specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0),
	           gl_FrontMaterial.shininess ) * texture2D(specularMap, texCoord).r;
	//vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;
//	vSpecular = gl_LightSource[i].specular * gl_FrontMaterial.specular * specular *
	vSpecular = gl_LightSource[i].specular * specular *
		texture2D(lightMap, vec2(specular-0.01,lightMapSelect[i]));

	accvSpecular = accvSpecular + vSpecular;
	}
   }

	//gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular);
	//gl_FragColor = ( vAmbient*base + vDiffuse*base + vSpecular) * att;
	//gl_FragColor = ( vAmbient*base + vDiffuse*base + texture2D(lightMap, vec2(1.0-specular,0))) * att;
	eVec=eyeVec[0];
	//float alpha = clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0);
	//float alpha = clamp(dot(vVec, vVec), 0.0, 1.0);
	//float alpha = (1.0f-clamp(((abs(clamp(vVec , 0.0, 1.0)-0.5))*2),0.0,1.0));
	float alpha = texture2D(lightMap, vec2(0.0,clamp(vVec/1.0, 0.1, 1.0))) ;
	//result=( vAmbient*base + clamp(accvDiffuse,1.0,1.0)*base );
	result=( clamp(accvDiffuse,1.0,1.0)*base );
	//result=vec4(0.5);
	//result = texture2D(colorMap, texCoord);
	gl_FragColor = result*alpha;

}


*/
